#!/bin/sh
#/* AbiWord build scripts
# * Copyright (c) 2004 Hubert Figuiere
# * 
# * This program is free software; you can redistribute it and/or
# * modify it under the terms of the GNU General Public License
# * as published by the Free Software Foundation; either version 2
# * of the License, or (at your option) any later version.
# * 
# * This program is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# * GNU General Public License for more details.
# * 
# * You should have received a copy of the GNU General Public License
# * along with this program; if not, write to the Free Software
# * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# * 02111-1307, USA.
# */


# Fink root setup dir. Not supposed to change as it is 
# hardcoded into the libraries
FINK_LIB_DIR=/sw/lib

# this is the DEPOT dir, the directory where to find 
# libs to copy from. By default it is the Fink lib dir
if [ x$FINK_DEPOT_DIR = x ] 
then
	FINK_DEPOT_DIR=$FINK_LIB_DIR
fi

EMBED_LIB_DIR=@executable_path/../Frameworks

# TODO: extract dependencies from, in that order
#  -wpd
#  -gsf
#  -gthread
#  -gobject
#  -glib
#  -xml2
#  -intl
#  -iconv
#  -bz2

WPDLIBS="libwpd-0.8.dylib libwpd-stream-0.8.dylib"
MATHLIBS="libmathview_frontend_libxml2.0.dylib libmathview.0.dylib"

DYLIBS="libgsf-1.1.dylib libgthread-2.0.dylib libgobject-2.0.dylib libglib-2.0.dylib libxml2.2.dylib libintl.1.dylib libiconv.2.dylib libbz2.1.dylib"

# add optional libwpd...

wpdlibs_all_found="yes"
wpdlibs_not_found=""

for i in $WPDLIBS ; do
    if [ ! -f $FINK_LIB_DIR/$i ] ; then
	wpdlibs_all_found="no"
	wpdlibs_not_found="$wpdlibs_not_found $i"
    fi
done

if [ $wpdlibs_all_found = "yes" ] ; then
    DYLIBS="$DYLIBS $WPDLIBS"
else
    echo "Can't find $wpdlibs_not_found. WordPerfect plugin not built."
fi

mathlibs_all_found="yes"
mathlibs_not_found=""

for i in $MATHLIBS ; do
    if [ ! -f $FINK_LIB_DIR/$i ] ; then
	mathlibs_all_found="no"
	mathlibs_not_found="$mathlibs_not_found $i"
    fi
done

if [ $mathlibs_all_found = "yes" ] ; then
    DYLIBS="$DYLIBS $MATHLIBS"
else
    echo "Can't find $mathlibs_not_found. abimathview plugin not built."
fi

for i in $DYLIBS ; do
    if [ ! -f $FINK_LIB_DIR/$i ] ; then
	echo "Can't find $FINK_LIB_DIR/$i in Fink. Build failed."
	exit 1
    fi
    if [ $FINK_LIB_DIR/$i -nt $SYMROOT/$i ]; then
	echo "Copying $FINK_DEPOT_DIR/$i to $SYMROOT"
	# copy following the link (ie copy the link target) 
	# and force override if needed (bug 6317)
	cp -Lf $FINK_DEPOT_DIR/$i $SYMROOT
	echo "Setting install name."
	install_name_tool \
		-id $EMBED_LIB_DIR/$i $SYMROOT/$i

    fi
done
