/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */



#ifndef _OPENDOCUMENT_CONTENTSTREAM_LISTENER_H_
#define _OPENDOCUMENT_CONTENTSTREAM_LISTENER_H_


// Internal includes
#include "OpenDocument_Stream_Listener.h"
#include "OpenDocument_StylesStream_Listener.h"

// abi includes
#include <ut_stack.h>





/**
 * Class to handle the content stream
 */
class ABI_EXPORT OpenDocument_ContentStream_Listener :
        public OpenDocument_Stream_Listener
{


public:
    OpenDocument_ContentStream_Listener (
        IE_Imp_OpenDocument* pImporter,
        OpenDocument_StylesStream_Listener* pSSListener);

    virtual ~OpenDocument_ContentStream_Listener () {}

    virtual void startElement (const XML_Char* pName, const XML_Char** ppAtts);

    virtual void endElement (const XML_Char* pName);
    
    virtual void charData (const XML_Char* pBuffer, int length);

    
private:
    UT_UCS4String m_charData;
    bool m_bAcceptingText;
    bool m_bInSection;
    bool m_bInTOC;

    UT_UTF8String m_curStyleName;

    UT_GenericVector<XML_Char*>   m_vecInlineFmt;
    UT_Stack      m_stackFmtStartIndex;
    const OpenDocument_StylesStream_Listener * m_pSSListener;

    UT_uint32 m_imgCnt;

    int m_row;
    int m_col;
    int m_cel;


    void _insertImage (const XML_Char** ppAtts);
    void _insureInBlock(const XML_Char** ppAtts);
    void _insureInSection(const XML_Char* pProps);
    void _insertBookmark (const XML_Char * name, const XML_Char * type);
    void _flush ();
    void _openTable (const XML_Char** ppProps);
    void _openColumn (const XML_Char** ppProps);
    void _openRow (const XML_Char** ppProps);
    void _openCell (const XML_Char** ppProps);
    void _closeTable ();
    void _closeColumn ();
    void _closeRow ();
    void _closeCell ();
    void _defineSimpleStyle (const XML_Char** ppProps);
    const XML_Char* _mapStyle (const XML_Char* pName) const;
    const OO_Style * _mapStyleObj (const XML_Char * name, UT_UTF8String & oo_sty) const;
    bool _pushInlineFmt(const XML_Char** ppAtts);
    void _popInlineFmt(void);
    static UT_Error _loadStream ( GsfInfile * oo, const char * stream, UT_ByteBuf & buf );
  
};





#endif //_OPENDOCUMENT_CONTENTSTREAM_LISTENER_H_
