/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


// Class definition include
#include "OpenDocument_StylesStream_Listener.h"



/**
 * 
 */
OpenDocument_StylesStream_Listener::
    OpenDocument_StylesStream_Listener (IE_Imp_OpenDocument* pImporter)
            : OpenDocument_Stream_Listener (pImporter),
                m_ooStyle (0),
                m_pageMaster(0)
{
}





/**
 * 
 */
OpenDocument_StylesStream_Listener::~OpenDocument_StylesStream_Listener()
{
    m_styleNameMap.purgeData();
}







/**
 * 
 */
UT_UTF8String OpenDocument_StylesStream_Listener::getStyleName(
                                            const UT_UTF8String& in) const
{
    UT_UTF8String* pName = m_styleNameMap.pick(in.utf8_str());
    
    if (!pName) {
        return UT_UTF8String(in);
    } else {
        return *pName;
    }
}









/**
 * 
 */
void OpenDocument_StylesStream_Listener::startElement (
                                                    const XML_Char* pName,
                                                    const XML_Char** ppAtts) 
{
    /* SXW || ODT */
    if (!UT_strcmp (pName, "style:page-master") ||
        !UT_strcmp (pName, "style:page-layout")) {
        
        m_pageMaster = UT_getAttribute("style:name", ppAtts);
        
    } else if (!UT_strcmp (pName, "style:master-page")) {
        
        const XML_Char* masterName =
            UT_getAttribute("style:page-master-name", ppAtts);
            
        const XML_Char** pageAtts = m_ooPageStyle.getAbiPageAtts(masterName);
        getDocument()->setPageSizeFromFile(pageAtts);
        
    } else if (!strcmp (pName, "style:style")) {
        
        const XML_Char* pAttr = NULL;

        pAttr = UT_getAttribute("style:name", ppAtts);
        
        if (pAttr) {
            m_name = pAttr;
        }

        pAttr = UT_getAttribute("style:display-name",ppAtts);
        
        if (pAttr) {
            m_displayName = pAttr;
        }

        if (m_name != "Standard") {
            pAttr = UT_getAttribute("style:parent-style-name", ppAtts);
            if (pAttr) {
                if (!UT_strcmp(pAttr, "Standard")) {
                    m_parent = "Normal";
                } else {
                    m_parent = pAttr;
                }
            }
    
            pAttr = UT_getAttribute("style:next-style-name", ppAtts);
            if (pAttr) {
                if (!UT_strcmp(pAttr, "Standard")) {
                    m_next = "Normal";
                } else {
                    m_next = pAttr;
                }
            }

            pAttr = UT_getAttribute("style:family", ppAtts);
            if (pAttr && strcmp (pAttr, "paragraph") != 0)
                m_type = CHARACTER;
            else
                m_type = PARAGRAPH;
            
        } else {
            // importantly map standard back to "Normal"
            m_parent = "Normal";
            m_next = "Normal";
            m_type = PARAGRAPH;
        }
        
        DELETEP(m_ooStyle);
        m_ooStyle = NULL;
        
        
    } else if (/* SXW || ODT */
    
        (!strcmp (pName, "style:properties") || !strcmp (pName, "style:page-layout-properties")) && 
         m_pageMaster) {
        // page setup, because we are in page-master subtree
        m_ooPageStyle.appendPageMaster(m_pageMaster, ppAtts);
        
    } else if (!strcmp (pName, "style:properties") ||              /* SXW */
         !strcmp (pName, "style:text-properties") ||         /* ODT */
         !strcmp (pName, "style:paragraph-properties")) {
      
        if (m_ooStyle == NULL) {
            getDocument()->getStyle (m_parent.utf8_str(), &m_pParentStyle);
            m_ooStyle = new OO_Style (ppAtts, m_pParentStyle);
        } else {
            m_ooStyle->parse(ppAtts);
        }
    }
}























/**
 * 
 */
void OpenDocument_StylesStream_Listener::endElement (const XML_Char* pName)
{
    if (!UT_strcmp (pName, "style:page-master")) {
        m_pageMaster = NULL;
    } else if (!strcmp (pName, "style:style")) {
        
        if (m_name.size ()) {
            int propCtr = 0;

            const XML_Char * atts[11];
            atts[propCtr++] = "type";
            atts[propCtr++] = (m_type == PARAGRAPH ? "P" : "C");

            atts[propCtr++] = "name";
            
            if (m_displayName.size()) {  
                atts[propCtr++] = m_displayName.utf8_str();
                
                m_styleNameMap.insert (m_name.utf8_str(),
                    new UT_UTF8String(m_displayName));
                    
            } else {
                atts[propCtr++] = m_name.utf8_str();
                
                m_styleNameMap.insert (m_name.utf8_str(),
                    new UT_UTF8String(m_name));
            }

            if (m_ooStyle) {
                atts[propCtr++] = "props";
                atts[propCtr++] = m_ooStyle->getAbiStyle ();
            }

            if (m_parent.size ()) {
                atts[propCtr++] = "basedon";
                atts[propCtr++] = m_parent.utf8_str();
            }

            if (m_next.size ()) {
                atts[propCtr++] = "followedby";
                atts[propCtr++] = m_next.utf8_str();
            }

            // must be last
            atts[propCtr] = 0;
            getDocument()->appendStyle(atts);
        }

        m_name.clear ();
        m_displayName.clear ();
        m_parent.clear ();
        m_next.clear ();
        DELETEP(m_ooStyle);
        m_ooStyle = NULL;
    }
}






/**
 * 
 */
const XML_Char* OpenDocument_StylesStream_Listener::getSectionProps() const 
{
    if (!UT_strcmp (m_ooPageStyle.getName(), "")) {
        UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
        return NULL;
    }
    
    return m_ooPageStyle.getAbiSectionProps();
}