/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
 
 // Class definition include
 #include "OO_SettingsWriter.h"
 
// Internal includes
#include "OO_Common.h"

// Abiword includes
#include <ut_types.h>
 
 
bool OO_SettingsWriter::writeSettings(PD_Document* pDoc, GsfOutfile* oo)
{
    GsfOutput* pSettings = gsf_outfile_new_child (oo, "settings.xml", FALSE);

    static const char * const preamble [] = 
    {
        "<?xml version='1.0' encoding='UTF-8'?>\n",
        "<!DOCTYPE office:document-settings PUBLIC '-//OpenOffice.org//DTD OfficeDocument 1.0//EN' 'office.dtd'>\n",
        "<office:document-settings xmlns:office='http://openoffice.org/2000/office' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:config='http://openoffice.org/2001/config' office:version='1.0'>\n",
        "<office:settings>\n",
        "</office:settings>\n",
        "</office:document-settings>"
    };

    oo_writeToStream (pSettings, preamble, NrElements(preamble));

    oo_gsf_output_close(pSettings);

    return true;
}