#include <iconv.h>

#define CPNAME_OR_FALLBACK(name,fallbackname)  \
{      \
       static char* cpname = NULL;                             \
       if (!cpname)    \
               {       \
                       iconv_t cd = iconv_open(name,name);     \
                       if (cd==(iconv_t)-1)    \
                               {       \
                                       cpname = fallbackname;  \
                               }       \
                       else    \
                               {       \
                                       cpname = name;  \
                                       iconv_close(cd);        \
                               }       \
               };      \
       return cpname;  \
}

const char *
wvLIDToCodePageConverter (unsigned short lid)
{
    if (lid == 0x0FFF)	/*Macintosh Hack */
	  return ("MACINTOSH");

    switch (lid & 0xff)
	  {
      case 0x01:		/*Arabic */
	  return ("CP1256");
      case 0x02:		/*Bulgarian */
	  return ("CP1251");
      case 0x03:		/*Catalan */
	  return ("CP1252");
      case 0x04:		/*Chinese */
      switch (lid)
		{
#if 0
      	case 0x1404:		/*Chinese (Macau SAR) */
#endif
      	case 0x0c04:		/*Chinese (Hong Kong SAR, PRC) */
	  	CPNAME_OR_FALLBACK ("CP950", "BIG5-HKSCS");
      	case 0x0804:		/*Chinese (PRC) */
	  	CPNAME_OR_FALLBACK ("CP936", "GBK");
#if 0
      	case 0x1004:		/*Chinese (Singapore) */
#endif
      	case 0x0404:		/*Chinese (Taiwan) */
	  	CPNAME_OR_FALLBACK ("CP950", "BIG5");
		}
      case 0x05:		/*Czech */
	  return ("CP1250");
      case 0x06:		/*Danish */
	  return ("CP1252");
      case 0x07:		/*German */
	  return ("CP1252");
      case 0x08:		/*Greek */
	  return ("CP1253");
      case 0x09:		/*English */
	  return ("CP1252");
      case 0x0a:		/*Spanish */
	  return ("CP1252");
      case 0x0b:		/*Finnish */
	  return ("CP1252");
      case 0x0c:		/*French */
	  return ("CP1252");
      case 0x0d:		/*Hebrew */
	  return ("CP1255");
      case 0x0e:		/*Hungarian */
	  return ("CP1250");
      case 0x0f:		/*Icelandic */
	  return ("CP1252");
      case 0x10:		/*Italian */
	  return ("CP1252");
      case 0x11:		/*Japanese */
	  return ("CP932");
      case 0x12:		/*Korean */
      switch (lid)
		{
      	case 0x0812:		/*Korean (Johab) */
	  	return ("CP1361");
      	case 0x0412:		/*Korean */
	  	return ("CP949");
		}
      case 0x13:		/*Dutch */
	  return ("CP1252");
      case 0x14:		/*Norwegian */
	  return ("CP1252");
      case 0x15:		/*Polish */
	  return ("CP1250");
      case 0x16:		/*Portuguese */
	  return ("CP1252");
      case 0x17:		/*Rhaeto-Romanic */
	  return ("CP1252");
      case 0x18:		/*Romanian */
	  return ("CP1250");
      case 0x19:		/*Russian */
	  return ("CP1251");
      case 0x1a:		/*Serbian, Croatian, (Bosnian?) */
      switch (lid)
		{
      	case 0x041a:		/*Croatian */
	  	return ("CP1252");
      	case 0x0c1a:		/*Serbian (Cyrillic) */
	  	return ("CP1251");
      	case 0x081a:		/*Serbian (Latin) */
	  	return ("CP1252");
		}
      case 0x1b:		/*Slovak */
	  return ("CP1250");
      case 0x1c:		/*Albanian */
	  return ("CP1251");
      case 0x1d:		/*Swedish */
	  return ("CP1252");
      case 0x1e:		/*Thai */
	  return ("CP874");
      case 0x1f:		/*Turkish */
	  return ("CP1254");
      case 0x20:		/*Urdu. This is Unicode only. */
	  return ("0");
      case 0x21:		/*Bahasa Indonesian */
	  return ("CP1252");
      case 0x22:		/*Ukrainian */
	  return ("CP1251");
      case 0x23:		/*Byelorussian / Belarusian */
	  return ("CP1251");
      case 0x24:		/*Slovenian */
	  return ("CP1250");
      case 0x25:		/*Estonian */
	  return ("CP1257");
      case 0x26:		/*Latvian */
	  return ("CP1257");
      case 0x27:		/*Lithuanian */
	  return ("CP1257");
      case 0x29:		/*Farsi / Persian. This is Unicode only. */
	  return ("0");
      case 0x2a:		/*Vietnamese */
	  return ("CP1258");
      case 0x2b:		/*Windows 2000: Armenian. This is Unicode only. */
	  return ("CP0");
      case 0x2c:		/*Azeri */
      switch (lid)
		{
      	case 0x082c:		/*Azeri (Cyrillic) */
	  	return ("CP1251");
#if 0
      	case 0x042c:		/*Azeri (Latin) */
#endif
		}
      case 0x2d:		/*Basque */
	  return ("CP1252");
      case 0x2f:		/*Macedonian */
	  return ("CP1251");
#if 0
      case 0x30:		/*Sutu */
#endif
      case 0x36:		/*Afrikaans */
	  return ("CP1252");
      case 0x37:		/*Windows 2000: Georgian. This is Unicode only. */
	  return ("CP0");
      case 0x38:		/*Faeroese */
	  return ("CP1252");
      case 0x39:		/*Windows 2000: Hindi. This is Unicode only. */
	  return ("CP0");
      case 0x3E:		/*Malaysian / Malay */
	  return ("CP1252");
#if 0
      case 0x3f:		/*Kazakh */
#endif
      case 0x41:		/*Swahili */
	  return ("CP1252");
      case 0x43:		/*Uzbek */
      switch (lid)
		{
      	case 0x0843:		/*Uzbek (Cyrillic) */
	  	return ("CP1251");
#if 0
      	case 0x0443:		/*Uzbek (Latin) */
#endif
		}
#if 0
      case 0x44:		/*Tatar */
#endif
      case 0x45:		/*Windows 2000: Bengali. This is Unicode only. */
      case 0x46:		/*Windows 2000: Punjabi. This is Unicode only. */
      case 0x47:		/*Windows 2000: Gujarati. This is Unicode only. */
      case 0x48:		/*Windows 2000: Oriya. This is Unicode only. */
      case 0x49:		/*Windows 2000: Tamil. This is Unicode only. */
      case 0x4a:		/*Windows 2000: Telugu. This is Unicode only. */
      case 0x4b:		/*Windows 2000: Kannada. This is Unicode only. */
      case 0x4c:		/*Windows 2000: Malayalam. This is Unicode only. */
      case 0x4d:		/*Windows 2000: Assamese. This is Unicode only. */
      case 0x4e:		/*Windows 2000: Marathi. This is Unicode only. */
      case 0x4f:		/*Windows 2000: Sanskrit. This is Unicode only. */
	  return ("CP0");
      case 0x55:		/*Myanmar / Burmese. This is Unicode only. */
	  return ("CP0");
      case 0x57:		/*Windows 2000: Konkani. This is Unicode only. */
	  return ("CP0");
#if 0
      case 0x58:		/*Manipuri */
      case 0x59:		/*Sindhi */
      case 0x60:		/*Kashmiri (India) */
#endif
      case 0x61:		/*Windows 2000: Nepali (India). This is Unicode only. */
	  return ("CP0");
      };

	/* TODO output a warning since this is a guess */
    return ("CP1252");
}
