/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "ut_Tree.h"

#import "HanAbiAPTPanel.h"
#import "HanAbiTreeView.h"

@interface HanAbiTreeViewItem : NSObject
{
	const UT_Node *		m_node;
	NSString *			m_value;
}
- (id)initWithNode:(const UT_Node *)node;
- (void)dealloc;

- (const UT_Node *)node;
- (NSString *)value;
@end

@implementation HanAbiTreeViewItem

- (id)initWithNode:(const UT_Node *)node
{
	self = [super init];

	m_node = node;

	UT_UTF8String value;

	switch (node->type ())
		{
		case UT_Node::nt_element:
			value  = "<";
			value += static_cast<const UT_Element *>(node)->ElementTag ();
			value += " ...";
			break;
		case UT_Node::nt_text:
			value = "\" ... \"";
			break;
		case UT_Node::nt_cdata:
			value = "<![CDATA[ ... ]]>";
			break;
		case UT_Node::nt_pi:
			value  = "<?";
			value += static_cast<const UT_PI_Node *>(node)->target ();
			value += " ... ?>";
			break;
		case UT_Node::nt_comment:
			value = "<!-- ... -->";
			break;
		case UT_Node::nt_default:
			value = "DEFAULT";
			break;
		case UT_Node::nt_other:
		default:
			value = "??";
			break;
		}
	m_value = (NSString *) [[NSString alloc] initWithUTF8String:(value.utf8_str ())];

	return self;
}

- (void)dealloc
{
	[m_value release];
	[super dealloc];
}

- (const UT_Node *)node
{
	return m_node;
}

- (NSString *)value
{
	return m_value;
}

@end

@implementation HanAbiTreeView

- (id)initWithTree:(const UT_Tree *)tree
{
	self = [super initWithWindowNibName:@"TreeView"];

	m_tree = tree;

	return self;
}

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item
{
	const UT_Node * node = 0;

	if (item)
		{
			HanAbiTreeViewItem * tvi = (HanAbiTreeViewItem *) item;
			const UT_Element * element = static_cast<const UT_Element *>([tvi node]);
			node = (*element)[static_cast<UT_uint32>(index)];
		}
	else
		{
			node = (*m_tree)[static_cast<UT_uint32>(index)];
		}
	return [[HanAbiTreeViewItem alloc] initWithNode:node];
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
	HanAbiTreeViewItem * tvi = (HanAbiTreeViewItem *) item;
	return ([tvi node]->type () == UT_Node::nt_element) ? YES : NO;
}

- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
	int count = 0;

	if (item)
		{
			HanAbiTreeViewItem * tvi = (HanAbiTreeViewItem *) item;
			const UT_Element * element = static_cast<const UT_Element *>([tvi node]);
			count = static_cast<int>(element->nodes ());
		}
	else
		{
			count = m_tree ? static_cast<int>(m_tree->nodes ()) : 0;
		}
	return count;
}

- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
	HanAbiTreeViewItem * tvi = (HanAbiTreeViewItem *) item;
	return [tvi value];
}

- (IBAction)aTreeView:(id)sender
{
	int index = [sender selectedRow];

	HanAbiAPTPanel * panel = [HanAbiAPTPanel sharedAPTPanel];
	if (panel)
		{
			if (index == -1)
				{
					[panel setNode:0];
				}
			else
				{
					HanAbiTreeViewItem * item = (HanAbiTreeViewItem *) [sender itemAtRow:index];
					if (item)
						[panel setNode:[item node]];
					else
						[panel setNode:0];
				}
		}
}

@end
