/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <Carbon/Carbon.h>

#include "ut_debugmsg.h"

#import "HanAbiDocumentController.h"
#import "HanAbiToolbar.h"

pascal OSStatus DoWindowClose (EventHandlerCallRef nextHandler, EventRef theEvent, void * userData)
{
	HanAbiToolbar * toolbar = (HanAbiToolbar *) userData;

	if (toolbar)
		[toolbar toggleState:nil]; 

	return noErr;
}

@implementation HanAbiToolbar

- (id)initWithTitle:(NSString *)title
{
	m_menuitem = nil;

	m_title = title;
	[m_title retain];

	self = [super initWithWindow:nil];
	if (!self)
		return nil;

	CFBundleRef bundleRef = CFBundleGetMainBundle ();

	IBNibRef nibRef;
	OSStatus err = CreateNibReferenceWithCFBundle (bundleRef, CFSTR("CarbonToolbar"), &nibRef);

	CFRelease (bundleRef);

	if (err != noErr)
		{
			[self release];
			return nil;
		}

	WindowRef winref;
	err = CreateWindowFromNib (nibRef, CFSTR("CarbonToolbar"), &winref);

	DisposeNibReference (nibRef);

	if (err != noErr)
		{
			[self release];
			return nil;
		}

	NSWindow * window = (NSWindow *) [[NSWindow alloc] initWithWindowRef:winref];
	if (!window)
		{
			[self release];
			return nil;
		}

	EventTypeSpec eventType;

	eventType.eventClass = kEventClassWindow;
	eventType.eventKind  = kEventWindowClose;

	EventHandlerUPP handlerUPP = NewEventHandlerUPP(DoWindowClose);

	InstallWindowEventHandler (winref, handlerUPP, 1, &eventType, self, 0);

	[window setExcludedFromWindowsMenu:YES];
	[window setTitle:title];
	[window setReleasedWhenClosed:NO];

	[self setWindow:window];

	HanAbiDocumentController * documentController = nil;
	documentController = (HanAbiDocumentController *) [NSDocumentController sharedDocumentController];
	if (documentController)
		m_menuitem = [documentController addToolbarToMenu:self];

	return self;
}

- (void)dealloc
{
	[m_title release];
	[super dealloc];
}

- (void)close
{
	if (m_menuitem)
		{
			[[m_menuitem menu] removeItem:m_menuitem];
			// TODO: need to release?
			m_menuitem = nil;
		}
	[super close];
}

- (IBAction)showWindow:(id)sender
{
	if (m_menuitem)
		[m_menuitem setState:YES];
	[super showWindow:sender];
}

- (void)toggleState:(id)sender
{
	NSWindow * window = [self window];

	if ([window isVisible])
		{
			if (m_menuitem)
				[m_menuitem setState:NO];
			[window close];
		}
	else
		{
			if (m_menuitem)
				[m_menuitem setState:YES];
			[self showWindow:self];
		}
}

- (NSString *)title
{
	return m_title;
}

@end
