/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>

@class HanAbiPreferences;

class UT_Element;
class UT_Tree;

@interface HanAbiPreferences : NSObject
{
	UT_Tree *			m_tree;
	const UT_Element *	m_prefs;

	BOOL				m_changed;
	BOOL				m_system;

	HanAbiPreferences *	m_parent;
}
+ (HanAbiPreferences *)systemPrefs;
+ (HanAbiPreferences *)userPrefs;

- (HanAbiPreferences *)pluginPrefs:(NSString *)plugin;
- (HanAbiPreferences *)toolbarPrefs:(NSString *)toolbar;

- (id)initWithParent:(HanAbiPreferences *)prefs withTree:(UT_Tree *)tree forPlugin:(NSString *)plugin;
- (id)initWithParent:(HanAbiPreferences *)prefs withTree:(UT_Tree *)tree forToolbar:(NSString *)toolbar;
- (id)init;
- (void)dealloc;

- (NSString *)valueForOption:(NSString *)name;
- (BOOL)setValue:(NSString *)value forOption:(NSString *)name;

- (BOOL)prefsCanChange;
- (BOOL)prefsHaveChanged;
- (void)setPrefsHaveChanged;

- (BOOL)loadPrefsFromFile:(NSString *)filename generateIfNone:(BOOL)generate;
- (BOOL)loadSystemPrefs;
- (BOOL)loadUserPrefs;
- (BOOL)savePrefsToFile:(NSString *)filename;
- (BOOL)saveUserPrefs;
@end
