/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#import "HanAbiPluginManager.h"
#import "HanAbiPluginHandler.h"
#import "HanAbiPluginsPanel.h"

static HanAbiPluginsPanel * s_panel = nil;

@implementation HanAbiPluginsPanel

+ (HanAbiPluginsPanel *)sharedPluginsPanel
{
	return s_panel; // assume instantiated in MainMenu.nib
}

- (void)awakeFromNib
{
	if (s_panel == nil)
		s_panel = self;

	m_handlers = nil;
}

- (IBAction)aActivate:(id)sender
{
	int rowIndex = [oTableView selectedRow];
	if (rowIndex < 0)
		return; // huh?

	unsigned index = static_cast<unsigned>(rowIndex);

	HanAbiPluginHandler * handler = (HanAbiPluginHandler *) [m_handlers objectAtIndex:index];

	if ([handler isActive])
		[handler deactivate];
	else if ([handler activate] == NO)
		return;

	if ([handler isActive])
		{
			[oActivate setTitle:@"Deactivate"];
			[oActivate setEnabled:YES];
			[oOptions  setEnabled:YES];
		}
	else
		{
			[oActivate setTitle:@"Activate"];
			[oActivate setEnabled:YES];
			[oOptions  setEnabled:NO];
		}
	[oTableView reloadData];
}

- (IBAction)aClick:(id)sender
{
	int rowIndex = [oTableView selectedRow];
	if (rowIndex < 0)
		{
			[oActivate setEnabled:NO];
			[oOptions  setEnabled:NO];
			[oTextView setString:@""];
			return;
		}

	unsigned index = static_cast<unsigned>(rowIndex);

	HanAbiPluginHandler * handler = (HanAbiPluginHandler *) [m_handlers objectAtIndex:index];

	if ([handler isActive])
		{
			[oActivate setTitle:@"Deactivate"];
			[oActivate setEnabled:YES];
			[oOptions  setEnabled:YES];
		}
	else
		{
			[oActivate setTitle:@"Activate"];
			[oActivate setEnabled:YES];
			[oOptions  setEnabled:NO];
		}
	[oTextView setString:[handler description]];
}

- (IBAction)aOptions:(id)sender
{
	int rowIndex = [oTableView selectedRow];
	if (rowIndex < 0)
		return; // huh?

	unsigned index = static_cast<unsigned>(rowIndex);

	HanAbiPluginHandler * handler = (HanAbiPluginHandler *) [m_handlers objectAtIndex:index];

	[handler displayOptions];
}

- (void)reloadAndSelectHandler:(HanAbiPluginHandler *)handler
{
	if ([[self window] isVisible] == NO)
		[self showWindow:self];

	[oTableView reloadData];

	if (handler && m_handlers)
		{
			int count = static_cast<int>([m_handlers count]);

			for (int i = 0; i < count; i++)
				if ([m_handlers objectAtIndex:i] == handler)
					{
						[oTableView selectRow:i byExtendingSelection:NO];
						[self aClick:self];
						break;
					}
		}
}

/* NSTableDataSource informal protocol
 */
- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	if (m_handlers)
		{
			[m_handlers release];
			m_handlers = nil;
		}

	HanAbiPluginManager * HAPM = [HanAbiPluginManager defaultManager];
	if (HAPM)
		m_handlers = [HAPM handlers];

	if (m_handlers == nil)
		return 0;

	[m_handlers retain];

	return static_cast<int>([m_handlers count]);
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	if (rowIndex < 0)
		return nil; // ??

	unsigned index = static_cast<unsigned>(rowIndex);

	HanAbiPluginHandler * handler = (HanAbiPluginHandler *) [m_handlers objectAtIndex:index];

	NSString * value = nil;
	NSString * identifier = (NSString *) [aTableColumn identifier];

	if ([identifier isEqualToString:@"Active"])
		{
			if ([handler isActive])
				value = @"A";
			else
				value = @"";
		}
	else if ([identifier isEqualToString:@"Name"])
		{
			value = [handler name];
		}
	else
		{
			value = [handler version];
		}
	return value;
}

/* NSTableView delegate
 */
- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	// TODO
}

- (BOOL)tableView:(NSTableView *)aTableView shouldSelectRow:(int)rowIndex
{
	return YES;
}

@end
