/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>

@class HanAbiPluginHandler;

@interface HanAbiPluginsPanel : NSWindowController
{
	NSArray *	m_handlers;

	IBOutlet NSButton *		oActivate;
	IBOutlet NSButton *		oOptions;
	IBOutlet NSTableView *	oTableView;
	IBOutlet NSTextView *	oTextView;
}
+ (HanAbiPluginsPanel *)sharedPluginsPanel;

- (void)awakeFromNib;

- (IBAction)aActivate:(id)sender;
- (IBAction)aClick:(id)sender;
- (IBAction)aOptions:(id)sender;

- (void)reloadAndSelectHandler:(HanAbiPluginHandler *)handler;

/* NSTableDataSource informal protocol
 */
- (int)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;

/* NSTableView delegate
 */
- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;
- (BOOL)tableView:(NSTableView *)aTableView shouldSelectRow:(int)rowIndex;

@end
