/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>

class UT_Tree;

@class HanAbiPlugin;

@interface HanAbiPluginHandler : NSObject
{
	NSString *		m_name;
	NSString *		m_version;
	NSString *		m_description;
	NSString *		m_path;

	NSBundle *		m_bundle;

	HanAbiPlugin *	m_instance;

	UT_Tree *		m_config;
}
- (id)initWithBundlePath:(NSString *)path;
- (void)dealloc;

- (NSString *)name;
- (NSString *)version;
- (NSString *)description;

- (BOOL)readPluginConf:(NSString *)filename;
- (void)composeDescription;
- (const UT_Tree *)pluginConf;

- (NSString *)valueForOption:(NSString *)name;

- (BOOL)isLoaded;
- (BOOL)load;

- (BOOL)isActive;
- (BOOL)activate;
- (void)deactivate;

- (void)displayOptions;
@end
