/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#import "HanAbiPlugin.h"
#import "HanAbiPluginHandler.h"
#import "HanAbiPreferences.h"

@implementation HanAbiPlugin

- (id)initWithHandler:(HanAbiPluginHandler *)pluginHandler
{
	self = [super init];

	m_handler = pluginHandler;

	return self;
}

- (HanAbiPluginHandler *)handler
{
	return m_handler;
}

- (HanAbiPreferences *)userPrefs
{
	HanAbiPreferences * prefs = nil;

	if (m_handler)
		{
			NSString * name = [m_handler name];
			if (name)
				{
					HanAbiPreferences * userPrefs = [HanAbiPreferences userPrefs];
					if (userPrefs)
						prefs = [userPrefs pluginPrefs:name];
				}
		}
	return prefs;
}

- (HanAbiPreferences *)systemPrefs
{
	HanAbiPreferences * prefs = nil;

	if (m_handler)
		{
			NSString * name = [m_handler name];
			if (name)
				{
					HanAbiPreferences * systemPrefs = [HanAbiPreferences systemPrefs];
					if (systemPrefs)
						prefs = [systemPrefs pluginPrefs:name];
				}
		}
	return prefs;
}

- (NSString *)valueForOption:(NSString *)name
{
	NSString * value = nil;

	HanAbiPreferences * prefs = [self userPrefs];
	if (prefs)
		{
			value = [prefs valueForOption:name];
			if (value)
				return value;
		}
	prefs = [self systemPrefs];
	if (prefs)
		{
			value = [prefs valueForOption:name];
			if (value)
				return value;
		}
	return m_handler ? [m_handler valueForOption:name] : nil;
}

- (BOOL)setValue:(NSString *)value forOption:(NSString *)name
{
	HanAbiPreferences * prefs = [self userPrefs];

	return prefs ? [prefs setValue:value forOption:name] : NO;
}

- (void)displayOptions
{
	// 
}

@end
