/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "ut_exception.h"
#include "ut_debugmsg.h"
#include "ut_Tree.h"

static const UT_Element * s_GetOption (const UT_Element * parent, const UT_Element *& options, const char * key)
{
	const UT_Element * option = 0;

	options = 0;

	UT_uint32 children = parent->children ();
	UT_uint32 i;

	for (i = 0; i < children; i++)
		{
			const UT_Element * child = parent->child (i);

			if (child->ElementTag () == "options")
				{
					options = child;
					break;
				}
		}
	if (options)
		{
			children = options->children ();
			for (i = 0; i < children; i++)
				{
					const UT_Element * child = options->child (i);

					if (child->ElementTag () == "option")
						{
							const UT_UTF8String * name = child->Attr ("name");
							if (name)
								if (*name == key)
									{
										option = child;
										break;
									}
						}
				}
		}
	return option;
}

const char * HanAbi_GetOption (const UT_Element * parent, const char * key)
{
	if (!parent || !key)
		return 0;
	if (*key == 0)
		return 0;

	const UT_UTF8String * value = 0;

	const UT_Element * options = 0;
	const UT_Element * option  = s_GetOption (parent, options, key);

	if (option)
		value = option->Attr ("value");

	return value ? value->utf8_str () : 0;
}

bool HanAbi_SetOption (const UT_Element * parent, const char * key, const char * value)
{
	if (!parent || !key)
		return false;
	if (*key == 0)
		return false;

	bool okay = false;

	const UT_Element * options = 0;
	const UT_Element * option  = s_GetOption (parent, options, key);

	if (options)
		{
			if (option)
				{
					if (value)
						{
							okay = const_cast<UT_Element *>(option)->insAttr ("value", value);
						}
					else
						{
							UT_uint32 nodes = options->nodes ();

							for (UT_uint32 i = 0; i < nodes; i++)
								if ((*options)[i] == option)
									{
										const_cast<UT_Element *>(options)->deleteNode (i);
										okay = true;
										break;
									}
						}
				}
			else if (value) // otherwise a strange attempt to add a non-existent option
				{
					okay = true;

					UT_Element * element = 0;

					UT_TRY
						{
							element = new UT_Element("option","");
						}
					UT_CATCH(...)
						{
							element = 0;
						}
					if (element == 0)
						okay = false;

					if (okay)
						okay = element->insAttr ("name", key);
					if (okay)
						okay = element->insAttr ("value", value);
					if (okay)
						okay = const_cast<UT_Element *>(options)->appendNode (element);
					else if (element)
						delete element;
				}
		}
	return okay;
}
