/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <unistd.h>
#include <fcntl.h>

#import "HanAbiDocumentController.h"
#import "HanAbiPluginManager.h"
#import "HanAbiPreferences.h"
#import "HanAbiToolbar.h"

extern bool _UT_OutputMessage_Divert (const char * debug_filename);

@implementation HanAbiDocumentController

- (id)init
{
	self = [super init];

	m_LaunchTime = NO;
	m_ClickedPlugin = nil;

	return self;
}

- (void)dealloc
{
	if (m_ClickedPlugin)
		[m_ClickedPlugin release];

	[super dealloc];
}

- (id)openDocumentWithContentsOfFile:(NSString *)filename display:(BOOL)flag
{
	if ([filename hasSuffix:[[HanAbiPluginManager defaultManager] pluginSuffix]])
		{
			if (m_LaunchTime) // defer handling until applicationDidFinishLaunching
				{
					m_ClickedPlugin = filename;
					[m_ClickedPlugin retain];
				}
			else
				{
					[[HanAbiPluginManager defaultManager] loadPlugin:filename];
				}
			return nil;
		}
	return [super openDocumentWithContentsOfFile:filename display:flag];
}

- (BOOL)changeDirectory:(NSString *)directory
{
	NSFileManager * FM = [NSFileManager defaultManager];

	BOOL bIsDirectory;
	BOOL exists = [FM fileExistsAtPath:directory isDirectory:&bIsDirectory];

	if (exists && !bIsDirectory) // erk!
		return NO;

	if (!exists)
		{
			if ([FM createDirectoryAtPath:directory attributes:nil] == NO) // erk!
				return NO;
		}
	return [FM changeCurrentDirectoryPath:directory];
}

- (void)applicationWillFinishLaunching:(NSNotification *)aNotification
{
	m_LaunchTime = YES;

	const char * home = getenv ("HOME");
	if (home)
		{
			int fd = open (".", O_RDONLY, 0);

			if (chdir (home) == 0)
				{
					BOOL okay = NO;

					if ([self changeDirectory:@"Library"])
						if ([self changeDirectory:@"Application Support"])
							if ([self changeDirectory:@"AbiSuite"])
								if ([self changeDirectory:@"HanAbi"])
									{
										okay = (_UT_OutputMessage_Divert ("HanAbi-debug.txt") ? YES : NO);
										[self changeDirectory:@"Plug-ins"]; // to create the directory, if not there
									}
					if (okay == NO)
						{
							chdir (home);
							_UT_OutputMessage_Divert ("HanAbi-debug.txt");
						}
					fchdir (fd);
				}
			close (fd);
		}

	/* have to do this at some point, now's as good a time as any...
	 */
	[HanAbiPreferences systemPrefs];
	[HanAbiPreferences userPrefs];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	[[HanAbiPluginManager defaultManager] queryPlugins];

	if (m_ClickedPlugin)
		{
			[[HanAbiPluginManager defaultManager] loadPlugin:m_ClickedPlugin];
			[m_ClickedPlugin release];
			m_ClickedPlugin = nil;
		}
	m_LaunchTime = NO;
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	HanAbiPreferences * userPrefs = [HanAbiPreferences userPrefs];
	if (userPrefs)
		if ([userPrefs prefsHaveChanged])
			{
				[userPrefs saveUserPrefs];
			}
}

- (NSMenuItem *)addToolbarToMenu:(HanAbiToolbar *)toolbar
{
	if (!toolbar)
		return nil;

	NSMenu * menu = [oToolbarsMenu submenu];
	if (!menu)
		return nil;

	NSString * title = [toolbar title];

	SEL sel = @selector(toggleState:);

	NSMenuItem * item = (NSMenuItem *) [[NSMenuItem alloc] initWithTitle:title action:sel keyEquivalent:@""];
	if (item)
		{
			[item setTarget:toolbar];
			[menu addItem:item];
		}
	return item;
}

@end
