/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "ut_debugmsg.h"
#include "ut_exception.h"
#include "ut_tree.h"

#import "HanAbiDocument.h"
#import "HanAbiTreeView.h"

@implementation HanAbiDocument

NSString * HanAbi_DocType_HanAbi = @"HanAbi plugin";
NSString * HanAbi_DocType_abw = @"AbiWord document";

- (id)init
{
	self = [super init];

	UT_TRY
		{
			m_tree = new UT_Tree;
		}
	UT_CATCH(...)
		{
			m_tree = 0;
		}
	return self;
}

- (void)dealloc
{
	if (m_tree)
		delete m_tree;

	[super dealloc];
}

- (NSData *)dataRepresentationOfType:(NSString *)aType
{
	if ([aType isEqualToString:HanAbi_DocType_HanAbi])
		return nil;
	// 
	return [NSData data]; // TODO
}

- (BOOL)loadDataRepresentation:(NSData *)docData ofType:(NSString *)docType
{
	if (!m_tree)
		return NO;

	if ([docType isEqualToString:HanAbi_DocType_HanAbi])
		return NO;

	if ([docData length] == 0)
		return NO;

	return m_tree->parse (reinterpret_cast<const char *>([docData bytes]), static_cast<UT_uint32>([docData length]));
}

- (BOOL)readFromFile:(NSString *)fileName ofType:(NSString *)docType
{
	if ([docType isEqualToString:HanAbi_DocType_HanAbi])
		return NO;
	return [super readFromFile:fileName ofType:docType];
}

- (void)makeWindowControllers
{
	HanAbiTreeView * tv = (HanAbiTreeView *) [[HanAbiTreeView alloc] initWithTree:m_tree];
	[tv showWindow:self];
	[self addWindowController:tv];
}

@end
