/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "ut_debugmsg.h"
#include "ut_Tree.h"

#import "HanAbiAPTDelegate.h"
#import "HanAbiAPTPanel.h"

static HanAbiAPTPanel * s_panel = nil;

@implementation HanAbiAPTPanel

+ (HanAbiAPTPanel *)sharedAPTPanel
{
	return s_panel; // assume instantiated in MainMenu.nib
}

- (void)awakeFromNib
{
	if (s_panel == nil)
		s_panel = self;

	m_node = 0;
}

- (void)setNode:(const UT_Node *)node
{
	if (m_node == node)
		{	
			if ([[self window] isVisible] == NO)
				[self showWindow:self];
			return;
		}
	m_node = node;

	if (!m_node)
		{
			[oAttributes setMap:0];
			[oProperties setMap:0];
			[oText setString:@""];
			return;
		}
	switch (m_node->type ())
		{
		case UT_Node::nt_element:
			{
				const UT_Element * element = static_cast<const UT_Element *>(m_node);

				[oAttributes setMap:(element->Attrs ())];
				[oProperties setMap:(element->Props ())];

				[self setTextLabel:[NSString stringWithUTF8String:(element->ElementTag().utf8_str ())]];

				[oText setString:@""]; // TODO: handle text view
				break;
			}
		case UT_Node::nt_text:
			{
				const UT_Text_Node * text_node = static_cast<const UT_Text_Node *>(m_node);

				[oAttributes setMap:0];
				[oProperties setMap:0];

				[self setTextLabel:@"(text)"];

				NSString * text = [NSString stringWithUTF8String:(text_node->text().utf8_str ())];
				[oText setString:text];
				break;
			}
		case UT_Node::nt_cdata:
			{
				const UT_CDATA_Node * cdata_node = static_cast<const UT_CDATA_Node *>(m_node);

				[oAttributes setMap:0];
				[oProperties setMap:0];

				[self setTextLabel:@"(CDATA)"];

				NSString * text = [NSString stringWithUTF8String:(cdata_node->text().utf8_str ())];
				[oText setString:text];
				break;
			}
		case UT_Node::nt_pi:
			{
				const UT_PI_Node * pi_node = static_cast<const UT_PI_Node *>(m_node);

				[oAttributes setMap:0];
				[oProperties setMap:0];

				NSString * label = @"?";
				NSString * target = [NSString stringWithUTF8String:(pi_node->target().utf8_str ())];
				[self setTextLabel:[label stringByAppendingString:target]];

				NSString * text = [NSString stringWithUTF8String:(pi_node->text().utf8_str ())];
				[oText setString:text];
				break;
			}
		case UT_Node::nt_comment:
			{
				const UT_Comment_Node * comment_node = static_cast<const UT_Comment_Node *>(m_node);

				[oAttributes setMap:0];
				[oProperties setMap:0];

				[self setTextLabel:@"(comment)"];

				NSString * text = [NSString stringWithUTF8String:(comment_node->text().utf8_str ())];
				[oText setString:text];
				break;
			}
		case UT_Node::nt_default:
			{
				const UT_Default_Node * default_node = static_cast<const UT_Default_Node *>(m_node);

				[oAttributes setMap:0];
				[oProperties setMap:0];

				[self setTextLabel:@"(default)"];

				NSString * text = [NSString stringWithUTF8String:(default_node->text().utf8_str ())];
				[oText setString:text];
				break;
			}
		case UT_Node::nt_other:
		default:
			{
				[oAttributes setMap:0];
				[oProperties setMap:0];
				[self setTextLabel:@"(other)"];
				[oText setString:@""];
				break;
			}
		}
	if ([[self window] isVisible] == NO)
		[self showWindow:self];
}

- (void)setTextLabel:(NSString *)label
{
	int tab = [oTabView indexOfTabViewItemWithIdentifier:@"Text"];
	[[oTabView tabViewItemAtIndex:tab] setLabel:label];
}

@end
