/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord / AbiBits / HanAbi
 *
 * Copyright (C) 2003 AbiSource, Inc.
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "ut_Tree.h"

#import "HanAbiAPTDelegate.h"

@implementation HanAbiAPTDelegate

- (void)awakeFromNib
{
	m_map = 0;
}

- (void)setMap:(const UT_UTF8Hash *)map
{
	if (m_map == map)
		return;

	m_map = map;

	[oTableView reloadData];
}

- (IBAction)aClick:(id)sender
{
	// TODO
}

/* NSTableDataSource informal protocol
 */
- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	if (!m_map)
		return 0;

	return static_cast<int>(m_map->count ());
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	const UT_UTF8String * name  = 0;
	const UT_UTF8String * value = 0;

	m_map->pair (static_cast<UT_uint32>(rowIndex), name, value);

	NSString * entry = nil;

	if ([[aTableColumn identifier] isEqualToString:@"name"])
		entry = [NSString stringWithUTF8String:(name->utf8_str ())];
	else
		entry = [NSString stringWithUTF8String:(value->utf8_str ())];

	return entry;
}

/* NSTableView delegate
 */
- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	// TODO
}

- (BOOL)tableView:(NSTableView *)aTableView shouldSelectRow:(int)rowIndex
{
	// TODO
	return NO;
}

@end
