/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 * Copyright (C) 2003 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#include <stdlib.h>

#include "ut_exception.h"

#include "pd_AbiWord_2.h"

PD_AbiWord_2::Attr_Core * PD_AbiWord_2::Attr_Core::attr_core (const char * old_id, const char * new_id,
															  const char * style_class, PropertyMap * style)
{
	if ((new_id == 0) || (style == 0)) return 0;

	UT_UTF8String * str_old_id = 0;
	if (old_id)
		{
			UT_TRY
				{
					str_old_id = new UT_UTF8String(old_id);
				}
			UT_CATCH(...)
				{
					str_old_id = 0;
				}
			if (str_old_id == 0) return 0;
		}

	UT_UTF8String * style_class = 0;
	if (style_class)
		{
			UT_TRY
				{
					str_style_class = new UT_UTF8String(style_class);
				}
			UT_CATCH(...)
				{
					str_style_class = 0;
				}
			if (str_style_class == 0)
				{
					if (str_old_id) delete str_old_id;
					return 0;
				}
		}

	Attr_Core * Core = 0;
	UT_TRY
		{
			Core = new Attr_Core(str_old_id,new_id,str_style_class,style);
		}
	UT_CATCH(...)
		{
			Core = 0;
		}
	if (Core == 0)
		{
			if (str_old_id)
				delete str_old_id;
			if (str_style_class)
				delete str_style_class;
		}
	return Core;
}

PD_AbiWord_2::Attr_Core::Attr_Core (UT_UTF8String * old_id, const char * new_id,
									UT_UTF8String * style_class, PropertyMap * style) :
	m_old_id(old_id),
	m_new_id(new_id),
	m_style_class(style_class),
	m_style(style)
{
	// 
}

PD_AbiWord_2::Attr_Core::~Attr_Core ()
{
	if (m_old_id)
		delete m_old_id;
	if (m_style_class)
		delete m_style_class;
	delete m_style;
}

bool PD_AbiWord_2::Attr_Core::append (UT_UTF8String & cache, bool strip)
{
	cache += " id=\"";
	cache += m_new_id;
	cache += "\"";

	if (old_id && !strip)
		{
			cache += " old-id=\"";
			cache += *m_old_id;
			cache += "\"";
		}
	if (m_style_class)
		{
			cache += " class=\"";
			cache += *m_style_class;
			cache += "\"";
		}
	return m_style->append (cache, strip);
}

PD_AbiWord_2::Attr_I18N * PD_AbiWord_2::Attr_I18N::attr_i18n (const char * xml_lang, const char * dir)
{
	UT_UTF8String * str_xml_lang = 0;
	if (xml_lang)
		{
			UT_TRY
				{
					str_xml_lang = new UT_UTF8String(xml_lang);
				}
			UT_CATCH(...)
				{
					str_xml_lang = 0;
				}
			if (str_xml_lang == 0) return 0;
		}

	TextDirection td = dir_default;
	if (dir)
		{
			if (strcmp (dir, "ltr") == 0)
				td = td_ltr;
			else if (strcmp (dir, "rtl") == 0)
				td = td_rtl;
		}

	Attr_I18N * I18N = 0;
	UT_TRY
		{
			I18N = new Attr_I18N(str_xml_lang,td);
		}
	UT_CATCH(...)
		{
			I18N = 0;
		}
	if (I18N == 0)
		{
			if (str_xml_lang)
				delete str_xml_lang;
		}
	return I18N;
}

PD_AbiWord_2::Attr_I18N::Attr_I18N (UT_UTF8String * xml_lang, TextDirection dir) :
	m_xml_lang(xml_lang),
	m_dir(dir)
{
	// 
}

PD_AbiWord_2::Attr_I18N::~Attr_I18N ()
{
	if (m_xml_lang) delete m_xml_lang;
}

bool PD_AbiWord_2::Attr_I18N::append (UT_UTF8String & cache, bool /* strip */)
{
	if (m_xml_lang)
		{
			cache += " xml:lang=\"";
			cache += *m_xml_lang;
			cache += "\"";
		}
	switch (m_dir)
		{
		case dir_ltr:
			cache += " dir=\"ltr\"";
			break;
		case dir_rtl:
			cache += " dir=\"rtl\"";
			break;
		default:
			break;
		}
	return true;
}

#if 0

General:

Property Name			CSS Equiv Name		Values in AbiWord
------------------------------------------------------------------------------------------------
bgcolor					background-color	<6-digit hex (no #)> | transparent
color					color				<6-digit hex (no #)>
dir-override			dir					ltr | rtl
dom-dir					??					ltr | rtl
field-font				??					(?)
font-family				font-family			generic | <single font name (unquoted)>
font-size				font-size			(?)
font-stretch			??					normal | (?)
font-style				font-style			normal | italic
font-variant			font-variant		(?)
font-weight				font-weight			normal | bold
height					height				(?)
keep-together			??					(?)
keep-with-next			??					(?)
lang					??					(?)
line-height				??					(?)
list-tag				??					(?)
margin-bottom			margin-bottom		(?)
margin-left				margin-left			(?)
margin-right			margin-right		(?)
margin-top				margin-top			(?)
orphans					orphans				(?)
tabstops				??					(?)
text-align				text-align			left | right | center | justify
text-decoration			text-decoration		[underline || overline || line-through || topline || bottomline] | none
text-indent				text-indent			(?)
text-position			vertical-align		[superscript || subscript] | normal
widows					widows				(?)
width					width				(?)

Section:

Property Name			CSS Equiv Name		Values in AbiWord
------------------------------------------------------------------------------------------------
page-margin-footer		??					(?)
page-margin-header		??					(?)

Cells:

Property Name			CSS Equiv Name		Values in AbiWord
------------------------------------------------------------------------------------------------
bot-attach				??					(?)
left-attach				??					(?)
right-attach			??					(?)
top-attach				??					(?)

Tables:

Property Name			CSS Equiv Name		Values in AbiWord
------------------------------------------------------------------------------------------------
table-col-spacing		??					(?)
table-column-leftpos	??					(?)
table-column-props		??					(?)

??

>> Secondly, what is the meaning of the table property "table-col-spacing"?
>  The spacing between left edge of text of one column and the right edge of 
>  the next in the next column in a table.

Note: see http://www.w3.org/TR/2003/WD-CSS21-20030128/tables.html

#endif
